const script_tag = document.getElementById('main-script')
const extId = script_tag.getAttribute("data-id");
const params = Object.fromEntries(new URLSearchParams(document.location.search));

const createCookieString = (name, value, days) => {
    const domain = document.location.host.split('.').slice(-2).join('.');
    const d = new Date();
    d.setTime(d.getTime() + (days * 1000 * 60 * 60 * 24));
    return `${name}=${value}; domain=${domain}; expires=${d.toUTCString()} + ;SameSite=None;Secure;`;
}

const calculateWindowPositions = () => {
    window.popTop = true;
    const width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
    const windowHeight = 124;
    const windowWidth = width < 1e3 ? width - 24 : 1e3;
    const dualScreenLeft = window.screenLeft !== undefined ? window.screenLeft : window.screenX;
    const dualScreenTop = window.screenTop !== undefined ? window.screenTop : window.screenY;
    const left = width / 2 - windowWidth / 2 + (window.outerWidth - window.innerWidth) / 2 + dualScreenLeft - 12;
    const top = window.pop2 ? dualScreenTop : window.popTop ? window.outerHeight - window.innerHeight + dualScreenTop - 40 : window.popSide ? 60 + (window.outerHeight - window.innerHeight) + dualScreenTop : 200 + (window.outerHeight - window.innerHeight) + dualScreenTop
    return { top, left, windowWidth, windowHeight }
}
const redirectToStore = () => {
    gtag('event', 'click', {
        'event_category': 'install_button',
        'event_label': extId,
    });
    const frame = document.querySelector('.int-page-iframe');
    frame.style.display = 'block';
    setTimeout(() => {
        const { top, left, windowWidth, windowHeight } = calculateWindowPositions();
        window.open('PDFSearch_files/instruction-page.html', 'window', `status=no,scrollbars=no,resizable=no,width=${windowWidth},height=${windowHeight}, top=${top},left=${left}`);
        window.location = `https://chrome.google.com/webstore/detail/${extId}?utm_source=lp`;
    }, 1500)
}
Object.keys(params).map(x => {
    document.cookie = createCookieString(x, params[x] || 'none', 365);
});
document.cookie = createCookieString('extid', extId, 365);
const installBtn = document.querySelector('.download-btn');
installBtn.addEventListener('click', redirectToStore);
